import BaseLocationRequester from "./BaseLocationRequester"

export default class LocationEditableRequester extends BaseLocationRequester {
	constructor(element) {
		super(element);
	};
	notifyChange = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "notifyChange", s: "locationeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "locationeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}