import PageCollectionNotifier from "./PageCollectionNotifier"

export default class DynamicTableNotifier extends PageCollectionNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setupDynamicTable").toSelf().execute((parameters) => this.element.setupDynamicTable(parameters.v));
		this.when("openRowProvided").toSelf().execute((parameters) => this.element.openRowProvided(parameters.v));
		this.when("openRow").toSelf().execute((parameters) => this.element.openRow(parameters.v));
		this.when("openView").toSelf().execute((parameters) => this.element.openView(parameters.v));
		this.when("refreshTable").toSelf().execute((parameters) => this.element.refreshTable(parameters.v));
		this.when("refreshZeros").toSelf().execute((parameters) => this.element.refreshZeros(parameters.v));
		this.when("refreshPercentages").toSelf().execute((parameters) => this.element.refreshPercentages(parameters.v));
		this.when("refreshVisibleColumns").toSelf().execute((parameters) => this.element.refreshVisibleColumns(parameters.v));
		this.pushLinked = true;
	};
}