import ActionableNotifier from "./ActionableNotifier"

export default class ActionSplitNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshOption").toSelf().execute((parameters) => this.element.refreshOption(parameters.v));
		this.when("refreshOptions").toSelf().execute((parameters) => this.element.refreshOptions(parameters.v));
		this.pushLinked = true;
	};
}