import ActionableRequester from "./ActionableRequester"

export default class UploadRequester extends ActionableRequester {
	constructor(element) {
		super(element);
	};
	notifyUploading = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "notifyUploading", s: "upload", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	add = (value, progressCallback) => {
		if (this.addToHistory(value)) return;
		this.fileService.upload({ app: this.element.context, op: "add", s: "upload", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: value}, this.element.ownerUnit(), undefined, progressCallback);
	};
	execute = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "execute", s: "upload", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "upload", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}