import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Table21MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import Table21MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Table21Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Table21MoldNotifier(this);
		this.requester = new Table21MoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_879733616" mode="normal">
				</UiText>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Table21Mold));
DisplayFactory.register("Table21Mold", withStyles(styles, { withTheme: true })(withSnackbar(Table21Mold)));