import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class MicroSiteNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("renderPage").toSelf().execute((parameters) => this.element.renderPage(parameters.v));
		this.when("renderPageNotFound").toSelf().execute(() => this.element.renderPageNotFound());
		this.pushLinked = true;
	};
}