import BaseSelectorNotifier from "./BaseSelectorNotifier"

export default class SelectorCollectionBoxNotifier extends BaseSelectorNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshSelection").toSelf().execute((parameters) => this.element.refreshSelection(parameters.v));
		this.when("refreshMultipleSelection").toSelf().execute((parameters) => this.element.refreshMultipleSelection(parameters.v));
		this.when("close").toSelf().execute(() => this.element.close());
		this.pushLinked = true;
	};
}