import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiExport from "alexandria-ui-elements/src/displays/components/Export";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ExportExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ExportExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ExportExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ExportExamplesMoldNotifier(this);
		this.requester = new ExportExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_1856230726" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_1856230726.a1321010907" format="h6" mode="normal" value="No facets with from">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_1856230726.a_1477060371" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_1856230726.a_1477060371.a1577127772" title="export..." target="self" mode="Button" size="Medium" from={1322870400000} range={{min:-1,max:-1}}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_1856230726.a_59903154" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_1856230726.a_59903154.a2137995090" mode="normal" language="Html" value="Export(title=&quot;export...&quot;, from=&quot;2011-12-03T00:00:00Z&quot;) as Button">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_850088772" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_850088772.a_1451869217" format="h6" mode="normal" value="No facets with from and to">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_850088772.a_393062631" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_850088772.a_393062631.a1706210492" title="export..." target="self" mode="Button" size="Medium" from={1322870400000} to={1323302400000} min={1322697600000} max={1325289600000} range={{min:-1,max:7}}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_850088772.a_938852961" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a_850088772.a_938852961.a1726325463" mode="normal" language="Html" value="Button(title=&quot;export...&quot;) as Export&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;from=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;to=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;min=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;max=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;rangeMax=7 Days">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a1793631619" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a1793631619.a_1750485200" format="h6" mode="normal" value="No facets with options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a1793631619.a_1577685759" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a1793631619.a_1577685759.a1964375931" title="export..." target="self" mode="Button" size="Medium" range={{min:-1,max:-1}} options={["a","b"]}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a1793631619.a_637971426" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1599189414.a1793631619.a_637971426.a_42543520" mode="normal" language="Html" value="Button(title=&quot;export...&quot;) as Export(options=&quot;a&quot; &quot;b&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ExportExamplesMold));
DisplayFactory.register("ExportExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ExportExamplesMold)));