import { createTheme } from '@material-ui/core/styles';

const Theme = (function () {
	var theme = null;
	var provider = {
        defaultMode: () => {
            return "light";
        },
        isAutoMode: () => {
            return "light" == "auto";
        },
		create: (mode) => {
            const primary = mode == "dark" ? "#3f51b5" : "#3f51b5";
            const secondary = mode == "dark" ? "#ff9100" : "#ff9100";
            const error = mode == "dark" ? "#f44336" : "#f44336";
			theme = createTheme({
				palette : {
					type : mode,
					primary : { main: primary },
					secondary : { main: secondary },
					error : { main: error },
					contrastThreshold : "3",
					tonalOffset : "0.2",
					grey : {
						primary: "#888",
						secondary: '#ddd'
					}
				},
				typography : {
					fontFamily : '"-apple-system","BlinkMacSystemFont","Segoe UI","Roboto","Helvetica Neue","Arial","sans-serif","Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol"',
					fontSize : 13,
					useNextVariants: true
				},
				darkFormats: {
					h3: { color:'white' },
					whiteBackground: { background:'white',borderRadius:'3px',height:'100%', background:'#222' },
					filled: { background:'#efefef',padding:'8px',minHeight:'200px', background:'black' },
					filledNoAir: { background:'#efefef',minHeight:'200px', background:'black' },
					filledNoAirLarge: { background:'#efefef',minHeight:'400px', background:'black' },
					filledNoAirExtraLarge: { background:'#efefef',minHeight:'670px', background:'black' }
				},
				formats: {
					h1: { color:'#B71C1C',textShadow:'2px 2px 2px #fff' },
					h2: { color:'black',textShadow:'2px 2px 2px #fff' },
					h3: {  },
					h4: {  },
					h5: {  },
					h6: { lineHeight:'17pt' },
					body1: {  },
					body2: {  },
					subtitle1: {  },
					subtitle2: {  },
					white: { color:'white' },
					higgerFont: { fontSize:'50pt' },
					whiteBackground: { background:'white',borderRadius:'3px',height:'100%' },
					redBackground: { background:'red' },
					air: { padding:'10px 20px' },
					airTop: { marginTop:'10px' },
					airBottom: { marginBottom:'10px' },
					doubleAirLeft: { marginLeft:'20px' },
					doubleAirRight: { marginRight:'20px' },
					doubleAirBottom: { marginBottom:'20px' },
					airLeft: { marginRight:'10px' },
					airRight: { marginRight:'10px' },
					bold: { fontWeight:'bold' },
					containerAirMedium: { padding:'10px' },
					containerAirLarge: { padding:'20px' },
					filled: { background:'#efefef',padding:'8px',minHeight:'200px' },
					filledNoAir: { background:'#efefef',minHeight:'200px' },
					filledNoAirLarge: { background:'#efefef',minHeight:'400px' },
					filledNoAirExtraLarge: { background:'#efefef',minHeight:'670px' },
					autoHeight: { overflow:'auto',height:'200px' },
					autoOverflow: { overflow:'auto' },
					fullHeight: { height:'100%' },
					middleWidth: { width:'50%' },
					extraHeight: { height:'400px' },
					verticalExtraHeight: { height:'900px' },
					headerToolbar: { marginTop:'10px' },
					textCentered: { textAlign:'center' },
					facetsAbsolute: { color:'#888',fontSize:'10px' },
					valuesLabelFormat: { whiteSpace:'nowrap' },
					bordered: { border:'1px solid',width:'100%' },
					bottomBordered: { borderBottom:'1px solid' },
					topBordered: { borderTop:'1px solid' },
					paperFormat: { minHeight:'300px' },
					underline: { borderBottom:'1px dotted #ddd',width:'100%',marginBottom:'10px' },
					description: { fontSize:'10pt',color:'grey' },
					minTableHeight: { minHeight:'200px' },
					timelineSummaryHeight: { height:'150px' },
					redColor: { color:'red' },
					cardTitle: { textAlign:'left',color:'#B71A1C',padding:'10px' },
					cardContent: { textAlign:'left',padding:'10px' },
					noAir: { padding:'0' },
					widgetType: { color:'#888' },
					widgetDemo: { margin:'0 0 5px 0' }
				}
			});
            theme.isLight = () => {
                return theme.palette.type == "light";
            };
            theme.isDark = () => {
                return theme.palette.type == "dark";
            };
            theme.onChangeMode = (listener) => {
                theme.changeModeListener = listener;
            }
            theme.setMode = (mode) => {
                theme.changeModeListener(mode);
            }
			return theme;
		},
		get: () => {
			return theme;
		},
	};
	return provider;
})();

function property(name) {
    var theme = Theme.get();
    if (theme == null) return;
    var parts = name.split(".");
    var property = theme;
    for (var i=0; i<parts.length; i++) property = property[parts[i]];
    return property;
}

export default Theme;