import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiGrid from "alexandria-ui-elements/src/displays/components/Grid";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import GridExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import GridExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class GridExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new GridExamplesMoldNotifier(this);
		this.requester = new GridExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_433873834" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_433873834.a_1066113791" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_433873834.a_1066113791.a1330293069" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_433873834.a_1066113791.a1872499589" format="filledNoAir" layout="vertical flexible" spacing="8">
							<UiGrid context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_433873834.a_1066113791.a1872499589.a2084953623" noItemsMessage="No elements" pageSize={24} itemHeight={100} scrollingMark={true} selection="single">
							</UiGrid>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_433873834.a_1066113791.a984871282" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_433873834.a_1066113791.a984871282.a_1893892509" mode="normal" language="Html" value="">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(GridExamplesMold));
DisplayFactory.register("GridExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(GridExamplesMold)));