import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiKpi from "alexandria-ui-elements/src/displays/components/Kpi";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import KpiExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import KpiExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class KpiExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new KpiExamplesMoldNotifier(this);
		this.requester = new KpiExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a_918327761" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a_236863894" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a_236863894.a1240567044" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a_236863894.a1240567044.a972385852" label="Incidents" backgroundColor="#dddnull#ddd" mode="Circle" unit="" textColor="#F68A1C" backgroundColor="#dddnull#ddd" highlightedColor="black" value="100.0" size="Small" textPosition="Outside">
								</UiKpi>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a_236863894.a_1250651054" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a_236863894.a_1250651054.a_1579771108" label="CPU load" backgroundColor="#2095D6null#2095D6" mode="Square" unit="%" textColor="white" backgroundColor="#2095D6null#2095D6" highlightedColor="#92041A" value="80.0" size="Small" textPosition="Outside">
								</UiKpi>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a_236863894.a947569834" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a_236863894.a947569834.a163039228" label="Free disk space" backgroundColor="#D84646null#D84646" mode="Circle" unit="GB" textColor="white" backgroundColor="#D84646null#D84646" highlightedColor="#92041A" value="80.0" size="Small" textPosition="Outside">
								</UiKpi>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a1876326914" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a_199609079.a1876326914.a_654608671" mode="normal" language="Html" value="Kpi(label=&quot;Incidents&quot;, value=100, backgroundColor=&quot;#ddd&quot;, textColor=&quot;#F68A1C&quot;) kpi1
							Kpi(label=&quot;CPU load&quot;, value=80, backgroundColor=&quot;#2095D6&quot;, textColor=&quot;white&quot;, unit=&quot;%&quot;, mode=Square) kpi2
							Kpi(label=&quot;Free disk space&quot;, value=80, backgroundColor=&quot;#D84646&quot;, textColor=&quot;white&quot;, unit=&quot;GB&quot;) kpi3">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a_1964767180" format="h6" mode="normal" value="No facets, medium size">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a101309115" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a101309115.a1584065228" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a101309115.a1584065228.a_2125552573" label="Incidents" backgroundColor="#dddnull#ddd" mode="Circle" unit="" textColor="#F68A1C" backgroundColor="#dddnull#ddd" highlightedColor="black" value="100.0" size="Medium" textPosition="Outside">
								</UiKpi>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a101309115.a1280763368" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a101309115.a1280763368.a_276747671" label="CPU load" backgroundColor="#2095D6null#2095D6" mode="Square" unit="%" textColor="white" backgroundColor="#2095D6null#2095D6" highlightedColor="#92041A" value="80.0" size="Medium" textPosition="Outside">
								</UiKpi>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a101309115.a_1263517758" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a101309115.a_1263517758.a1895917311" label="Free disk space" backgroundColor="#D84646null#D84646" mode="Circle" unit="GB" textColor="white" backgroundColor="#D84646null#D84646" highlightedColor="#92041A" value="80.0" size="Medium" textPosition="Outside">
								</UiKpi>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a1430277599" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569789732.a860433233.a1430277599.a849667827" mode="normal" language="Html" value="Kpi(label=&quot;Incidents&quot;, value=100, backgroundColor=&quot;#ddd&quot;, textColor=&quot;#F68A1C&quot;, size=Medium)
							Kpi(label=&quot;CPU load&quot;, value=80, backgroundColor=&quot;#2095D6&quot;, textColor=&quot;white&quot;, unit=&quot;%&quot;, mode=Square, size=Medium)
							Kpi(label=&quot;Free disk space&quot;, value=80, backgroundColor=&quot;#D84646&quot;, textColor=&quot;white&quot;, unit=&quot;GB&quot;, size=Medium)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a2018721906" format="h6" mode="normal" value="No facets, large size and inside text position">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a826305885" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a826305885.a1298678676" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a826305885.a1298678676.a1518717603" label="Incidents" backgroundColor="#dddnull#ddd" mode="Circle" unit="" textColor="#F68A1C" backgroundColor="#dddnull#ddd" highlightedColor="black" value="100.0" size="Large" textPosition="Inside">
								</UiKpi>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a826305885.a437647351" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a826305885.a437647351.a1449664018" label="CPU load" backgroundColor="#2095D6null#2095D6" mode="Square" unit="%" textColor="white" backgroundColor="#2095D6null#2095D6" highlightedColor="#92041A" value="80.0" size="Large" textPosition="Inside">
								</UiKpi>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a826305885.a_966263214" format="doubleAirLeft doubleAirRight" layout="vertical">
								<UiKpi context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a826305885.a_966263214.a986768425" label="Free disk space" backgroundColor="#D84646null#D84646" mode="Circle" unit="GB" textColor="white" backgroundColor="#D84646null#D84646" highlightedColor="#92041A" value="80.0" size="Large" textPosition="Inside">
								</UiKpi>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a_1632272585" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_264867830.a_2077900197.a_1632272585.a_494596400" mode="normal" language="Html" value="Kpi(label=&quot;Incidents&quot;, value=100, backgroundColor=&quot;#ddd&quot;, textColor=&quot;#F68A1C&quot;, size=Large, textPosition=Inside)
							Kpi(label=&quot;CPU load&quot;, value=80, backgroundColor=&quot;#2095D6&quot;, textColor=&quot;white&quot;, unit=&quot;%&quot;, mode=Square, size=Large, textPosition=Inside)
							Kpi(label=&quot;Free disk space&quot;, value=80, backgroundColor=&quot;#D84646&quot;, textColor=&quot;white&quot;, unit=&quot;GB&quot;, size=Large, textPosition=Inside)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(KpiExamplesMold));
DisplayFactory.register("KpiExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(KpiExamplesMold)));