import Requester from "./Requester";

export default class EventlineRequester extends Requester {
	constructor(element) {
		super(element);
	};
	update = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "update", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	first = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "first", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	previous = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "previous", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	previousPage = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "previousPage", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	next = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "next", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	nextPage = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "nextPage", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	last = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "last", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	page = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "page", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	selectEvent = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "selectEvent", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	selectEvents = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "selectEvents", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	executeEvent = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "executeEvent", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "eventline", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}