import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiDateNavigator from "alexandria-ui-elements/src/displays/components/DateNavigator";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiReel from "alexandria-ui-elements/src/displays/components/Reel";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ReelExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ReelExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ReelExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ReelExamplesMoldNotifier(this);
		this.requester = new ReelExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826.a1606610031" format="doubleAirBottom" layout="vertical">
						<UiDateNavigator context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826.a1606610031.a1927869488">
						</UiDateNavigator>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826.a811671359" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826.a811671359.a1749676823" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826.a811671359.a_1863191955" format="filledNoAirExtraLarge" layout="vertical">
							<UiReel context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826.a811671359.a_1863191955.a718141701" format="doubleAirBottom">
							</UiReel>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826.a811671359.a_1863191955.a1937920048" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1290685826.a811671359.a_1863191955.a1937920048.a_1562374678" mode="normal" language="Html" value="Reel">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ReelExamplesMold));
DisplayFactory.register("ReelExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ReelExamplesMold)));