import Requester from "./Requester";

export default class WizardRequester extends Requester {
	constructor(element) {
		super(element);
	};
	back = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "back", s: "wizard", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	next = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "next", s: "wizard", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	finishConfirmed = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "finishConfirmed", s: "wizard", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	finish = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "finish", s: "wizard", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "wizard", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}