import Requester from "./Requester";

export default class ChatRequester extends Requester {
	constructor(element) {
		super(element);
	};
	executeOperation = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "executeOperation", s: "chat", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	sendMessage = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "sendMessage", s: "chat", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	sendAttachment = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "sendAttachment", s: "chat", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	uploadAttachment = (value) => {
		if (this.addToHistory(value)) return;
		this.fileService.upload({ app: this.element.context, op: "uploadAttachment", s: "chat", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: value}, this.element.ownerUnit());
	};
	previousMessages = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "previousMessages", s: "chat", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "chat", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}