import ActionableNotifier from "./ActionableNotifier"

export default class ToggleAppModeNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("toggle").toSelf().execute(() => this.element.toggle());
		this.pushLinked = true;
	};
}