import ActionableNotifier from "./ActionableNotifier"

export default class CloseAppNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("close").toSelf().execute(() => this.element.close());
		this.pushLinked = true;
	};
}