import PageCollectionNotifier from "./PageCollectionNotifier"

export default class GridNotifier extends PageCollectionNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshInfo").toSelf().execute((parameters) => this.element.refreshInfo(parameters.v));
		this.when("refreshVisibleColumns").toSelf().execute((parameters) => this.element.refreshVisibleColumns(parameters.v));
		this.when("refreshSort").toSelf().execute((parameters) => this.element.refreshSort(parameters.v));
		this.when("refreshGroupBy").toSelf().execute((parameters) => this.element.refreshGroupBy(parameters.v));
		this.when("refreshGroupByOptions").toSelf().execute((parameters) => this.element.refreshGroupByOptions(parameters.v));
		this.when("loadState").toSelf().execute((parameters) => this.element.loadState(parameters.v));
		this.when("addRow").toSelf().execute((parameters) => this.element.addRow(parameters.v));
		this.when("addRows").toSelf().execute((parameters) => this.element.addRows(parameters.v));
		this.pushLinked = true;
	};
}