import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class EventlineNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("refreshToolbar").toSelf().execute((parameters) => this.element.refreshToolbar(parameters.v));
		this.when("refreshEvent").toSelf().execute((parameters) => this.element.refreshEvent(parameters.v));
		this.when("resetEvents").toSelf().execute(() => this.element.resetEvents());
		this.when("addEventsBefore").toSelf().execute((parameters) => this.element.addEventsBefore(parameters.v));
		this.when("addEventsAfter").toSelf().execute((parameters) => this.element.addEventsAfter(parameters.v));
		this.when("scrollTo").toSelf().execute((parameters) => this.element.scrollTo(parameters.v));
		this.when("scrollToStart").toSelf().execute((parameters) => this.element.scrollToStart(parameters.v));
		this.when("scrollToEnd").toSelf().execute((parameters) => this.element.scrollToEnd(parameters.v));
		this.when("showLoading").toSelf().execute(() => this.element.showLoading());
		this.when("hideLoading").toSelf().execute(() => this.element.hideLoading());
		this.when("enableSelectEventsAction").toSelf().execute(() => this.element.enableSelectEventsAction());
		this.pushLinked = true;
	};
}