import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBoard from "alexandria-ui-elements/src/displays/components/Board";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import BoardExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import BoardExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class BoardExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new BoardExamplesMoldNotifier(this);
		this.requester = new BoardExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a1027890340" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a1027890340.a_1180761320" format="h6" mode="normal" value="Board with source from file">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a1027890340.a2039758400" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a1027890340.a2039758400.a1330313566" layout="vertical" width="-1px" height="600px">
								<UiBoard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a1027890340.a2039758400.a1330313566.a_252150852" icon="Apps">
								</UiBoard>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a1027890340.a2039758400.a_223994214" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a1027890340.a2039758400.a_223994214.a710261926" mode="normal" language="Html" value="Board board&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Source as FromFile(file=&quot;path/to/file.tsv&quot;, separator=&quot;\\t&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1346939854" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1346939854.a1503985491" format="h6" mode="normal" value="Board with source from resource">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1346939854.a715829967" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1346939854.a715829967.a1151888886" layout="vertical" width="-1px" height="600px">
								<UiBoard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1346939854.a715829967.a1151888886.a1656324571" icon="Apps">
								</UiBoard>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1346939854.a715829967.a1708797971" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1346939854.a715829967.a1708797971.a702061381" mode="normal" language="Html" value="Board board&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Source as FromResource(path=&quot;data/boards/board2.tsv&quot;, separator=&quot;\\t&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1714427427" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1714427427.a_1511439982" format="h6" mode="normal" value="Board with source inline">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1714427427.a_877138170" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1714427427.a_877138170.a1619939440" layout="vertical" width="-1px" height="600px">
								<UiBoard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1714427427.a_877138170.a1619939440.a_730167302" icon="Apps">
								</UiBoard>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1714427427.a_877138170.a_1531499564" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_636628606.a_1714427427.a_877138170.a_1531499564.a1950914349" mode="normal" language="Html" value="Board board&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Source as Inline&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Application(&quot;app1&quot;, &quot;http://app1.html&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Application(&quot;app2&quot;, &quot;http://app2.html&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(BoardExamplesMold));
DisplayFactory.register("BoardExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(BoardExamplesMold)));