import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class BaseLocationNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshZoom").toSelf().execute((parameters) => this.element.refreshZoom(parameters.v));
		this.when("refreshZoomRange").toSelf().execute((parameters) => this.element.refreshZoomRange(parameters.v));
		this.when("refreshCenter").toSelf().execute((parameters) => this.element.refreshCenter(parameters.v));
		this.pushLinked = true;
	};
}