import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiChat from "alexandria-ui-elements/src/displays/components/Chat";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ChatExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ChatExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ChatExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ChatExamplesMoldNotifier(this);
		this.requester = new ChatExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_977478134" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_977478134.a_838415325" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_977478134.a_475290589" format="extraHeight filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiChat context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_977478134.a_475290589.a_1332045356" label="Chat 1" view="Embedded" messageFlow="Continuous">
							</UiChat>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_977478134.a1246895539" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_977478134.a1246895539.a_686574152" mode="normal" language="Html" value="Chat(label=&quot;Chat 1&quot;,emptyMessage=&quot;Chat example. Write messages to see behavior&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_1754241168" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_1754241168.a549065715" format="h6" mode="normal" value="Floating view">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_1754241168.a_620767124" format="extraHeight filledNoAir" layout="horizontal end endjustified" spacing="8">
							<UiChat context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_1754241168.a_620767124.a_1528558860" label="Chat 2" view="Floating" width="500px" height="300px" messageFlow="Continuous">
							</UiChat>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_1754241168.a_840534709" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1958555639.a_1754241168.a_840534709.a_67674118" mode="normal" language="Html" value="Chat(label=&quot;Chat 2&quot;,emptyMessage=&quot;Chat example. Write messages to see behavior&quot;,view=Floating)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a_351952071" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a_351952071.a2122857897" format="h6" mode="normal" value="No facets with incoming/outgoing images">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a_351952071.a_448485591" format="extraHeight filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiChat context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a_351952071.a_448485591.a762440469" label="Chat 3" view="Embedded" messageFlow="Continuous">
							</UiChat>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a_351952071.a_684023924" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a_351952071.a_684023924.a_1395549673" mode="normal" language="Html" value="Chat(label=&quot;Chat 3&quot;,emptyMessage=&quot;Chat example. Start writing messages&quot;, incomingImage=&quot;icons/chat-incoming.png&quot;, outgoingImage=&quot;icons/chat-outgoing.png&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a1553010090" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a1553010090.a_879152677" format="h6" mode="normal" value="No facets with loading images">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a1553010090.a662492148" format="extraHeight filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiChat context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a1553010090.a662492148.a565926965" label="Chat 4" view="Embedded" messageFlow="Continuous">
							</UiChat>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a1553010090.a_1115547944" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1537049580.a1553010090.a_1115547944.a_1724349513" mode="normal" language="Html" value="Chat(label=&quot;Chat 4&quot;,emptyMessage=&quot;Chat example. Start writing messages&quot;, incomingImage=&quot;icons/chat-incoming.png&quot;, outgoingImage=&quot;icons/chat-outgoing.png&quot;, loadingImage=&quot;icons/chat-loading.png&quot;, messageFlow=InTurn)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ChatExamplesMold));
DisplayFactory.register("ChatExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ChatExamplesMold)));