import ActionableNotifier from "./ActionableNotifier"

export default class CopyToClipboardNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("copy").toSelf().execute((parameters) => this.element.copy(parameters.v));
		this.pushLinked = true;
	};
}