import ActionableNotifier from "./ActionableNotifier"

export default class OpenLayerNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("openAddress").toSelf().execute(() => this.element.openAddress());
		this.pushLinked = true;
	};
}