import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class ChartNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("showLoading").toSelf().execute(() => this.element.showLoading());
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshError").toSelf().execute((parameters) => this.element.refreshError(parameters.v));
		this.pushLinked = true;
	};
}