import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiDateNavigator from "alexandria-ui-elements/src/displays/components/DateNavigator";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTimeline from "alexandria-ui-elements/src/displays/components/Timeline";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TimelineExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TimelineExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TimelineExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TimelineExamplesMoldNotifier(this);
		this.requester = new TimelineExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a_739196739" format="doubleAirBottom" layout="vertical">
						<UiDateNavigator context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a_739196739.a960742039">
						</UiDateNavigator>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788920" format="airBottom timelineSummaryHeight" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788920.a1979657406" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788920.a_1779371802" format="filledNoAirExtraLarge" layout="vertical">
							<UiTimeline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788920.a_1779371802.a_1054853129" mode="Summary">
							</UiTimeline>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788920.a_1779371802.a1073454908" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788920.a_1779371802.a1073454908.a_1074794285" mode="normal" language="Html" value="Timeline">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788921" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788921.a_989292039" format="h6" mode="normal" value="No facets (Catalog mode)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788921.a708141062" format="filledNoAirExtraLarge" layout="vertical" width="-1px" height="500px">
							<UiTimeline context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788921.a708141062.a_1770242280" mode="Catalog">
							</UiTimeline>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788921.a708141062.a_114615949" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a574291761.a2004788921.a708141062.a_114615949.a229730834" mode="normal" language="Html" value="Timeline(mode=Catalog)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TimelineExamplesMold));
DisplayFactory.register("TimelineExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(TimelineExamplesMold)));