import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class MultipleImageNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.when("refreshImages").toSelf().execute((parameters) => this.element.refreshImages(parameters.v));
		this.when("reset").toSelf().execute(() => this.element.reset());
		this.pushLinked = true;
	};
}