import ActionableRequester from "./ActionableRequester"

export default class CopyToClipboardRequester extends ActionableRequester {
	constructor(element) {
		super(element);
	};
	execute = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "execute", s: "copytoclipboard", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	copied = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "copied", s: "copytoclipboard", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "copytoclipboard", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}