import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysItemMold from "ui-elements/gen/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Map1MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import Map1MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Map1Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Map1MoldNotifier(this);
		this.requester = new Map1MoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_494457164">
				</DisplaysItemMold>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Map1Mold));
DisplayFactory.register("Map1Mold", withStyles(styles, { withTheme: true })(withSnackbar(Map1Mold)));