import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class ChatNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshTitle").toSelf().execute((parameters) => this.element.refreshTitle(parameters.v));
		this.when("addPreviousMessages").toSelf().execute((parameters) => this.element.addPreviousMessages(parameters.v));
		this.when("addMessages").toSelf().execute((parameters) => this.element.addMessages(parameters.v));
		this.when("addMessagePart").toSelf().execute((parameters) => this.element.addMessagePart(parameters.v));
		this.when("messagesStartReached").toSelf().execute(() => this.element.messagesStartReached());
		this.when("open").toSelf().execute(() => this.element.open());
		this.when("closeMessage").toSelf().execute(() => this.element.closeMessage());
		this.pushLinked = true;
	};
}