import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HomeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HomeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class HomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HomeTemplateNotifier(this);
		this.requester = new HomeTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244029284" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244029284.a_1535418858" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244029284.a_1535418858.a839546164" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244029284.a_1535418858.a83164381" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244029284.a_1535418858.a_927298668" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244029284.a_1535418858.a_927298668.a413635787" mode="normal" value="home">
							</UiText>
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1244029284.a_1535418858.a_927298668.a_1203571876" title="widgets" target="self" mode="Link" size="Medium">
							</UiOpenPage>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1927242946" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1927242946.a_1012854307" layout="vertical center" width="70.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1927242946.a_1012854307.a_1434205185" format="h1 textCentered" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1927242946.a_1012854307.a560469080" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1927242946.a_1012854307.a_1416992944" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256" format="containerAirLarge" layout="vertical">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_744343960" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_744343960.a888199840" format="air h1" mode="normal" value="Why intino?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433" layout="horizontal centercenter" width="-1px" height="300px" spacing="40">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1411974660" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1411974660.a6709664" format="cardTitle h5" mode="normal" value="flexibility">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1411974660.a1847816420" format="cardContent h5" mode="normal" value="Extending benefits beyond software development into modifiability. With intino, software evolution is tailor-made, that is evolving systems built specifically for the needs of particular customer">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1258821103" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1258821103.a_2051806619" format="cardTitle h5" mode="normal" value="reuse">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1258821103.a_768585785" format="cardContent h5" mode="normal" value="Developing core components that can be reused. This is the strategy that creates an opportunity for benefits in reducing the effort and costs costs required to create, deploy and software">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1613913943" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1613913943.a_555959060" format="cardTitle h5" mode="normal" value="quality">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1053303256.a755345067.a_986792433.a1613913943.a_1334323762" format="cardContent h5" mode="normal" value="Lowering the complexity of product line development. Application developers can focus on user requirements, getting advantage on the platform architecture that provides a stable quality">
								</UiText>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013433194" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013433194.a1524819292" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013433194.a1524819292.a_284861237" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013433194.a1524819292.a_284861237.a1173976482" format="air h2 white" mode="normal" value="What does it look like?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013433194.a1524819292.a697605425" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_107874157" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_107874157.a416724596" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_107874157.a416724596.a_704573467" format="h1" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_107874157.a416724596.a_1958374496" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_107874157.a416724596.a359130776" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate));
DisplayFactory.register("HomeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate)));