import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class BaseSliderNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshOrdinals").toSelf().execute((parameters) => this.element.refreshOrdinals(parameters.v));
		this.when("refreshSelectedOrdinal").toSelf().execute((parameters) => this.element.refreshSelectedOrdinal(parameters.v));
		this.when("refreshToolbar").toSelf().execute((parameters) => this.element.refreshToolbar(parameters.v));
		this.when("refreshRange").toSelf().execute((parameters) => this.element.refreshRange(parameters.v));
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.when("refreshMarks").toSelf().execute((parameters) => this.element.refreshMarks(parameters.v));
		this.pushLinked = true;
	};
}