import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiOpenDrawer from "alexandria-ui-elements/src/displays/components/OpenDrawer";
import UiBlockDrawer from "alexandria-ui-elements/src/displays/components/BlockDrawer";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiCloseDrawer from "alexandria-ui-elements/src/displays/components/CloseDrawer";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiBlockSplitter from "alexandria-ui-elements/src/displays/components/BlockSplitter";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiBlockBadge from "alexandria-ui-elements/src/displays/components/BlockBadge";
import UiOpenPopover from "alexandria-ui-elements/src/displays/components/OpenPopover";
import UiBlockPopover from "alexandria-ui-elements/src/displays/components/BlockPopover";
import UiOpenBlock from "alexandria-ui-elements/src/displays/components/OpenBlock";
import UiCloseBlock from "alexandria-ui-elements/src/displays/components/CloseBlock";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import UiBlockResizable from "alexandria-ui-elements/src/displays/components/BlockResizable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import BlockExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import BlockExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class BlockExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new BlockExamplesMoldNotifier(this);
		this.requester = new BlockExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1707140883" icon="Clear">
				</UiMaterialIcon>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436.a_312807660" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436.a1280797982" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436.a1280797982.a_1534993617" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436.a1280797982.a_1534993617.a717051753" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436.a1280797982.a_1534993617.a1319122973" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436.a1280797982.a_1534993617.a1323214332" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436.a_39534937" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1648487436.a_39534937.a_457591164" mode="normal" language="Html" value="Block&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 2&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 3&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908.a_1313696454" format="h6" mode="normal" value="No facets with spacing">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908.a1953223189" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908.a1953223189.a1522174936" layout="vertical" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908.a1953223189.a1522174936.a_2021431456" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908.a1953223189.a1522174936.a_1419360236" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908.a1953223189.a1522174936.a_1415268877" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908.a_1087807941" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_206510908.a_1087807941.a285703179" mode="normal" language="Html" value="DP8">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690.a_159674929" format="h6" mode="normal" value="No facets with layout">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690.a_708034282" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690.a_708034282.a_696133246" layout="horizontal centercenter" width="-1px" height="175px" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690.a_708034282.a_696133246.a_1678464492" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690.a_708034282.a_696133246.a_1076393272" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690.a_708034282.a_696133246.a_1072301913" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690.a1065913079" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_543564690.a1065913079.a277502634" mode="normal" language="Html" value="Horizontal CenterCenter">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1286878510" layout="vertical" width="99.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1286878510.a889402038" format="h6" mode="normal" value="Parallax facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1286878510.a550421329" format="filled" layout="vertical" spacing="8">
							<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1286878510.a550421329.a_245205913" layout="vertical" width="-1px" height="175px">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1286878510.a550421329.a_245205913.a1602722931" layout="horizontal centercenter" width="100.0%" height="100.0%">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1286878510.a550421329.a_245205913.a1602722931.a_1932094101" format="body1 higgerFont white" mode="normal" value="pencils">
									</UiText>
								</UiBlock>
							</UiBlockParallax>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1286878510.a_1528868576" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1286878510.a_1528868576.a1281342860" mode="normal" language="Html" value="Block as Parallax(value=&quot;images/background1.jpg&quot;) Absolute(height=175px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_1702039395" format="h6" mode="normal" value="Drawer facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_2065895872" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_2065895872.a387383621" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_2065895872.a307067438" layout="vertical" width="300px" height="-1px" position="Left" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_2065895872.a307067438.a_356668777" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_2065895872.a307067438.a_356668777.a_912040845" name="Block_70_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_2065895872.a307067438.a_356668777.a1626049739" name="Block_71_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_503734192" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a918572477.a_503734192.a2025560724" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a1080168515" format="h6" mode="normal" value="Drawer facet with position">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a_1042568576" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a_1042568576.a444604525" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a_1042568576.a_770746286" layout="vertical" width="300px" height="-1px" position="Right" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a_1042568576.a_770746286.a2106614742" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a_1042568576.a_770746286.a2106614742.a_732006824" name="Block_89_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a_1042568576.a_770746286.a2106614742.a1683270737" name="Block_90_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a1461635640" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_58518632.a1461635640.a_1364763355" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock2)&lt;br/&gt;
							Block drawerBlock2 as Drawer(position=Right) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a590594157" format="h6" mode="normal" value="Drawer facet with Persistent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856.a_564733327" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856.a_755388737" layout="vertical" width="300px" height="-1px" position="Left" variant="Persistent">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856.a_755388737.a1167947151" layout="horizontal endjustified">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856.a_755388737.a1167947151.a1137946623" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856.a_755388737.a_245226027">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856.a_755388737.a_679285267" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856.a_755388737.a_679285267.a1289755777" name="Block_110_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_904697856.a_755388737.a_679285267.a_2043702531" name="Block_111_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_1945106015" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1547693780.a_1945106015.a575493365" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock3)&lt;br/&gt;
							Block drawerBlock3 as Drawer(variant=Persistent) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock3)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Divider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a669616392" format="h6" mode="normal" value="Drawer facet with PersistentAndMini variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640" format="filledNoAir" layout="horizontal">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129" layout="vertical" width="150px" height="-1px" position="Left" variant="PersistentAndMini">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_322917384" layout="horizontal endjustified" width="-1px" height="45px">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_322917384.a834384050" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_568981310">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_403510684" multipleSelection={false}>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_403510684.a1421857311" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_403510684.a1421857311.a_2094932732" title="Build option" icon="Build">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_403510684.a1421857311.a_1964870214" name="Block_132_97_01338594671" mode="normal" value="option 1">
										</UiText>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_403510684.a_554942612" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_403510684.a_554942612.a1145761089" title="Face option" icon="Face">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a419628129.a_403510684.a_554942612.a_76497113" name="Block_133_95_1458356688" mode="normal" value="option 2">
										</UiText>
									</UiBlock>
								</UiSelectorListBox>
							</UiBlockDrawer>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a1504052035" format="autoHeight" layout="vertical flexible">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a1504052035.a270195448" color="white" layout="horizontal startjustified">
									<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a1504052035.a270195448.a104042561" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
									</UiOpenDrawer>
								</UiBlock>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a1801567640.a1504052035.a1215403137" format="containerAirMedium" mode="normal" value="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tellus lacus, tristique vitae lectus id, tristique cursus est. Mauris dui dolor, lacinia non accumsan sed, lacinia et eros. Ut eget ornare nunc. Vestibulum at porta tellus, in fringilla tellus. Nam ultricies porta nisi, ut sagittis est lacinia ac. Nunc aliquet, lacus a malesuada pretium, arcu lectus egestas purus, vel euismod nisl ante eget augue. Proin tristique, arcu vitae vehicula cursus, odio nulla congue erat, at porttitor magna dui id quam. In hac habitasse platea dictumst. Etiam id lorem cursus, ultricies felis ut, pretium ante. Aliquam sit amet tellus tellus. Maecenas eget faucibus enim. Pellentesque rutrum augue id pulvinar pharetra. Proin purus ex, tincidunt et posuere vel, dignissim a neque. Aenean quis imperdiet lectus. Pellentesque bibendum ante tincidunt feugiat pharetra. Fusce sollicitudin, magna in mollis vulputate, nunc nunc accumsan lectus, a blandit erat felis a lectus.">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a_1405625783" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a619698483.a_1405625783.a_1048627031" mode="normal" language="Html" value="Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock1)
							Divider
							MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer(variant=PersistentAndMini) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886.a3704210" format="h6" mode="normal" value="Drawer facet with Permanent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886.a_1318777389" format="filledNoAir" layout="horizontal" spacing="8">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886.a_1318777389.a_1557706488" layout="vertical" width="150px" height="-1px" spacing="8" position="Left" variant="Permanent">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886.a_1318777389.a_1557706488.a1388841760" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886.a_1318777389.a_1557706488.a1388841760.a1724645484" name="Block_155_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886.a_1318777389.a_1557706488.a1388841760.a_1198389838" name="Block_156_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886.a1680907240" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_850429886.a1680907240.a438395065" mode="normal" language="Html" value="Block drawerBlock as Drawer(variant=Permanent) Absolute(width=150px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a_1745767261" format="h6" mode="normal" value="Splitter facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1998731933" format="filled" layout="vertical" spacing="8">
							<UiBlockSplitter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1998731933.a1914205341" layout="horizontal" splitMobileLabel="Back">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1998731933.a1914205341.a_394106788" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1998731933.a1914205341.a_394106788.a261765281" mode="normal" value="block 1">
									</UiText>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1998731933.a1914205341.a_394106788.a963959794" title="open 2" target="self" mode="Button" size="Medium">
									</UiAction>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1998731933.a1914205341.a_394106787" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1998731933.a1914205341.a_394106787.a80600170" mode="normal" value="block 2">
									</UiText>
								</UiBlock>
							</UiBlockSplitter>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1244465907" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_441037137.a1244465907.a_1492990302" mode="normal" language="Html" value="Block(layout=Horizontal) as Splitter&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_930215569" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_930215569.a_1048476532" format="h6" mode="normal" value="Badge facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_930215569.a_653068530" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlockBadge context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_930215569.a_653068530.a1913124699" layout="horizontal" mode="Normal" value={10}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_930215569.a_653068530.a1913124699.a1473777935" format="body1" mode="normal" value="value">
								</UiText>
							</UiBlockBadge>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_930215569.a403723378" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_930215569.a403723378.a764209353" mode="normal" language="Html" value="Block as Badge(value=10)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1563184237" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1563184237.a_857082435" format="h6" mode="normal" value="Popover facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1563184237.a_202961324" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1563184237.a_202961324.a1912923885" title="open popover" target="self" mode="Button" size="Medium" triggerEvent="MouseClick">
							</UiOpenPopover>
							<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1563184237.a_202961324.a_495571596" format="air" layout="horizontal" position="BottomCenter">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1563184237.a_202961324.a_495571596.a375820026" format="body1" mode="normal" value="popover content">
								</UiText>
							</UiBlockPopover>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1563184237.a1764474744" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1563184237.a1764474744.a_1942371008" mode="normal" language="Html" value="Button as OpenPopover(popover=popoverBlock)&lt;br/&gt;
							Block popoverBlock as Popover&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;popover content&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1148601949" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1148601949.a_517097298" format="h6" mode="normal" value="Popover facet with trigger event">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1148601949.a2079358791" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1148601949.a2079358791.a_318431715" title="open popover" target="self" mode="Button" size="Medium" triggerEvent="MouseOver">
							</UiOpenPopover>
							<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1148601949.a2079358791.a829398529" format="air" layout="horizontal" position="BottomCenter">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1148601949.a2079358791.a829398529.a_1408342268" format="body1" mode="normal" value="popover content">
								</UiText>
							</UiBlockPopover>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1148601949.a_1800901401" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a1148601949.a_1800901401.a1838837118" mode="normal" language="Html" value="Button as OpenPopover(popover=popoverBlock, triggerEvent=MouseOver)&lt;br/&gt;
							Block popoverBlock as Popover&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;popover content&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_1426186644" format="h6" mode="normal" value="Badge facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_311777923" format="filledNoAir" layout="vertical centercenter">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_311777923.a206100833" layout="vertical" width="80.0%" height="100.0%">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_311777923.a206100833.a_1374737276" layout="horizontal center">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_311777923.a206100833.a_1374737276.a_1021052708" format="airRight bold" mode="normal" value="Section title">
									</UiText>
									<UiOpenBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_311777923.a206100833.a_1374737276.a_1857265601" title="Open" target="self" mode="MaterialIconButton" icon="ExpandMore" size="Small">
									</UiOpenBlock>
									<UiCloseBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_311777923.a206100833.a_1374737276.a_595661791" title="Close" target="self" mode="MaterialIconButton" icon="ExpandLess" size="Small">
									</UiCloseBlock>
								</UiBlock>
								<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_311777923.a206100833.a_1832412149" format="topBordered" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_311777923.a206100833.a_1832412149.a1498573815" format="body1" mode="normal" value="Section content">
									</UiText>
								</UiBlockConditional>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_1434422565" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a319548021.a_1434422565.a1180290864" mode="normal" language="Html" value="Block as Relative(width=80%)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Section title&quot;, format=bold airRight)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;MaterialIconButton(title=&quot;Open&quot;, size=Small, icon=&quot;ExpandMore&quot;) as OpenBlock(conditionalBlock)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;MaterialIconButton(title=&quot;Close&quot;, size=Small, icon=&quot;ExpandLess&quot;) as CloseBlock(conditionalBlock)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(format=topBordered) conditionalBlock as Conditional&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Section content&quot;, format=body1)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_1738535419" format="h6" mode="normal" value="Resizable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_1667107931" format="filledNoAir" layout="vertical">
							<UiBlockResizable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_1667107931.a_1801618846" layout="horizontal flexible">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_1667107931.a_1801618846.a1340381033" format="fullHeight minTableHeight whiteBackground" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_1667107931.a_1801618846.a1340381033.a_1385988487" mode="normal" value="Block 1">
									</UiText>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_1667107931.a_1801618846.a_161944624" format="fullHeight minTableHeight redBackground" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_1667107931.a_1801618846.a_161944624.a1847315200" mode="normal" value="Block 2">
									</UiText>
								</UiBlock>
							</UiBlockResizable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_268310866" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_403286680.a_268310866.a160146031" mode="normal" language="Html" value="Block(layout=Horizontal) as Resizable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(format=fullHeight minTableHeight)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Block 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(format=fullHeight minTableHeight)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Block 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a34811822" format="h6" mode="normal" value="Vertical resizable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a693655452" format="filledNoAir" layout="vertical">
							<UiBlockResizable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a693655452.a1500552505" format="minTableHeight" layout="vertical flexible">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a693655452.a1500552505.a2125542793" format="fullHeight minTableHeight whiteBackground" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a693655452.a1500552505.a2125542793.a992990190" mode="normal" value="Block 1">
									</UiText>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a693655452.a1500552505.a_777940037" format="fullHeight minTableHeight redBackground" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a693655452.a1500552505.a_777940037.a81817472" mode="normal" value="Block 2">
									</UiText>
								</UiBlock>
							</UiBlockResizable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a_1522759542" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083374417.a_1706451104.a_1522759542.a419864876" mode="normal" language="Html" value="Block(layout=Vertical) as Resizable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(format=fullHeight minTableHeight)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Block 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(format=fullHeight minTableHeight)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Block 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(BlockExamplesMold));
DisplayFactory.register("BlockExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(BlockExamplesMold)));