import BaseNumberRequester from "./BaseNumberRequester"

export default class NumberEditableRequester extends BaseNumberRequester {
	constructor(element) {
		super(element);
	};
	notifyChange = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "notifyChange", s: "numbereditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "numbereditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}