import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class BaseIconNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshIcon").toSelf().execute((parameters) => this.element.refreshIcon(parameters.v));
		this.when("refreshTitle").toSelf().execute((parameters) => this.element.refreshTitle(parameters.v));
		this.pushLinked = true;
	};
}