import ActionableRequester from "./ActionableRequester"

export default class OpenLayerRequester extends ActionableRequester {
	constructor(element) {
		super(element);
	};
	execute = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "execute", s: "openlayer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	openLayer = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "openLayer", s: "openlayer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "openlayer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}