import BaseSelectorRequester from "./BaseSelectorRequester"

export default class SelectorCollectionBoxRequester extends BaseSelectorRequester {
	constructor(element) {
		super(element);
	};
	search = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "search", s: "selectorcollectionbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	clearSelection = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "clearSelection", s: "selectorcollectionbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	unSelect = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "unSelect", s: "selectorcollectionbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	open = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "open", s: "selectorcollectionbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	opened = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "opened", s: "selectorcollectionbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	selectOther = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "selectOther", s: "selectorcollectionbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "selectorcollectionbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}