import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiNumber from "alexandria-ui-elements/src/displays/components/Number";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiNumberEditable from "alexandria-ui-elements/src/displays/components/NumberEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import NumberExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import NumberExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NumberExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new NumberExamplesMoldNotifier(this);
		this.requester = new NumberExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_188610410" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_188610410.a1682844052" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_188610410.a_1938199425" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_188610410.a_1938199425.a1741434098" format="body1 widgetDemo" style="Number" value={0.0} decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_188610410.a_1938199425.a_340082701" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_188610410.a_1938199425.a_340082701.a_1115528958" mode="normal" language="Html" value="Number(value=10, label=&quot;Campo num&eacute;rico&quot;) number1&lt;br/&gt;
								in java called to number1.countDecimals(10)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1665422978" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1665422978.a_1719837546" format="h6" mode="normal" value="No facets with prefix and suffix">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1665422978.a868838138" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1665422978.a868838138.a1870516818" format="body1 widgetDemo" style="Number" value={0.0} prefix="Amount" suffix="$" decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1665422978.a868838138.a185880189" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1665422978.a868838138.a185880189.a_1625139614" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, prefix=&quot;Amount&quot;, suffix=&quot;$&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a829208632" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a829208632.a_1562504750" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a829208632.a955645296" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a829208632.a955645296.a_1417143524" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true} helperText="Some important helper text">
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a829208632.a955645296.a_1516518324" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a829208632.a955645296.a_1516518324.a652665217" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) as Editable(helperText=&quot;Some important helper text&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1612287482" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1612287482.a_102600222" format="h6" mode="normal" value="Editable facet with error">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1612287482.a_1740407694" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1612287482.a_1740407694.a_1288060801" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true}>
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1612287482.a_1740407694.a_1457090075" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a1612287482.a_1740407694.a_1457090075.a_1625362767" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) as Editable">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a504378308" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a504378308.a1392270911" format="h6" mode="normal" value="No facets, Currency style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a504378308.a1037579251" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a504378308.a1037579251.a_774734056" format="body1 widgetDemo" style="Currency" value={1.0E8} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a504378308.a1037579251.a_1103894527" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a504378308.a1037579251.a_1103894527.a_2132113043" mode="normal" language="Html" value="Number(value=100000000, style=Currency, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a955435299" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a955435299.a_475817537" format="h6" mode="normal" value="No facets, Bytes style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a955435299.a137850420" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a955435299.a137850420.a_1114065142" format="body1 widgetDemo" style="Bytes" value={2.3232323E7} decimals={2} expanded={false}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a955435299.a137850420.a_538527962" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a955435299.a137850420.a_538527962.a_1745522619" mode="normal" language="Html" value="Number(value=23232323, style=Bytes, countDecimals=2, expanded=false)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_509253215" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_509253215.a_1424292622" format="h6" mode="normal" value="No facets, Exponential style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_509253215.a1674786336" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_509253215.a1674786336.a510766573" format="body1 widgetDemo" style="Exponential" value={1.2398734202E7} decimals={2} expanded={false}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_509253215.a1674786336.a1691859055" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211976708.a_509253215.a1674786336.a1691859055.a_2089373432" mode="normal" language="Html" value="Number(value=12398734.202, style=Exponential, countDecimals=2, expanded=false)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(NumberExamplesMold));
DisplayFactory.register("NumberExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(NumberExamplesMold)));