import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenLayer from "alexandria-ui-elements/src/displays/components/OpenLayer";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiCloseLayer from "alexandria-ui-elements/src/displays/components/CloseLayer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LayerExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LayerExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LayerExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LayerExamplesMoldNotifier(this);
		this.requester = new LayerExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1240314941" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1240314941.a_2101570724" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1240314941.a685893318" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenLayer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1240314941.a685893318.a_1661163857" title="open layer" target="self" mode="Button" size="Medium">
							</UiOpenLayer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1240314941.a816815590" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1240314941.a816815590.a335056876" mode="normal" language="Html" value="Button(title=&quot;open layer&quot;) as OpenLayer">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1754309128" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1754309128.a_1955769144" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1754309128.a2043937699" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiCloseLayer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1754309128.a2043937699.a1907541888" title="close layer" target="self" mode="Button" size="Medium">
							</UiCloseLayer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1754309128.a1434446721" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203184519.a_1754309128.a1434446721.a_1344417149" mode="normal" language="Html" value="Button(title=&quot;open layer&quot;) as CloseLayer">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(LayerExamplesMold));
DisplayFactory.register("LayerExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(LayerExamplesMold)));