import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSlider from "alexandria-ui-elements/src/displays/components/Slider";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemporalSlider from "alexandria-ui-elements/src/displays/components/TemporalSlider";
import UiRangeSlider from "alexandria-ui-elements/src/displays/components/RangeSlider";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SliderExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SliderExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SliderExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SliderExamplesMoldNotifier(this);
		this.requester = new SliderExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1764273256" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1764273256.a1815546668" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1764273256.a_421105418" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1764273256.a_421105418.a_60326974" format="containerAirLarge" arrangement="Horizontal" position="SliderTop" range={{min:1,max:100}} value={-1}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1764273256.a1282783964" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1764273256.a1282783964.a_1005512901" mode="normal" language="Html" value="Slider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1100158939" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1100158939.a_1952860027" format="h6" mode="normal" value="No facets with Animation property">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1100158939.a_599239633" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1100158939.a_599239633.a769820324" format="containerAirLarge" arrangement="Horizontal" animation={{interval:3000,loop:true}} position="SliderTop" range={{min:1,max:100}} value={-1}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1100158939.a_699129946" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1100158939.a_699129946.a240756858" mode="normal" language="Html" value="Slider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Animation(interval=100 Millis, loop=true)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a411593206" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a411593206.a1553274767" format="h6" mode="normal" value="Temporal facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a411593206.a710921648" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiTemporalSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a411593206.a710921648.a_1993935096" format="containerAirLarge" arrangement="Horizontal" position="SliderTop">
							</UiTemporalSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a411593206.a_426325557" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a411593206.a_426325557.a_1750922575" mode="normal" language="Html" value="TemporalSlider slider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;scales=Day Month Year">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a618508404" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a618508404.a_1232070112" format="h6" mode="normal" value="No facets with ToolbarOnly style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a618508404.a1433941800" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a618508404.a1433941800.a_1340947454" format="containerAirLarge" arrangement="Horizontal" style="ToolbarOnly" position="SliderTop" range={{min:1,max:100}} value={-1}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a618508404.a_1608660892" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a618508404.a_1608660892.a_523174908" mode="normal" language="Html" value="Slider(style=ToolbarOnly)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a249203824" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a249203824.a1464028737" format="h6" mode="normal" value="No facets with SliderOnly style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a249203824.a_1494218250" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a249203824.a_1494218250.a_510800156" format="containerAirLarge" arrangement="Horizontal" style="SliderOnly" position="SliderTop" range={{min:1,max:100}} value={-1}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a249203824.a_1778831089" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a249203824.a_1778831089.a_588822338" mode="normal" language="Html" value="Slider(style=SliderOnly)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_891129597" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_891129597.a370827258" format="h6" mode="normal" value="No facets with SliderOnly and Marks in Java">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_891129597.a204555986" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_891129597.a204555986.a319347142" format="containerAirLarge" arrangement="Horizontal" style="SliderOnly" position="SliderTop" range={{min:1,max:100}} value={-1}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_891129597.a_889616111" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_891129597.a_889616111.a1207038204" mode="normal" language="Html" value="Slider(style=SliderOnly)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_843783955" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_843783955.a1093168061" format="h6" mode="normal" value="No facets with slider on bottom">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_843783955.a_1481730467" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_843783955.a_1481730467.a1149494440" format="containerAirLarge" arrangement="Horizontal" position="SliderBottom" range={{min:1,max:100}} value={-1}>
							</UiSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_843783955.a_1665458168" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_843783955.a_1665458168.a1926064509" mode="normal" language="Html" value="Slider(position=SliderBottom)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1909019912" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1909019912.a_1509884427" format="h6" mode="normal" value="Range slider. No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1909019912.a252196952" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiRangeSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1909019912.a252196952.a1979641738" format="containerAirLarge" range={{min:-100,max:10000}} value={[-80,3000]} minimumDistance={10}>
							</UiRangeSlider>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1909019912.a_1326949047" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_170285318.a_1909019912.a_1326949047.a_1429319960" mode="normal" language="Html" value="RangeSlider(from=5,to=30,minimumDistance=10)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Range(min=1,max=100)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(SliderExamplesMold));
DisplayFactory.register("SliderExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(SliderExamplesMold)));