import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorTabs from "alexandria-ui-elements/src/displays/components/SelectorTabs";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiSelectorMenu from "alexandria-ui-elements/src/displays/components/SelectorMenu";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiSelectorRadioBox from "alexandria-ui-elements/src/displays/components/SelectorRadioBox";
import UiSelectorToggleBox from "alexandria-ui-elements/src/displays/components/SelectorToggleBox";
import UiSelectorCheckBox from "alexandria-ui-elements/src/displays/components/SelectorCheckBox";
import UiSelectorCollectionBox from "alexandria-ui-elements/src/displays/components/SelectorCollectionBox";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import DisplaysSelector8ListMold from "ui-elements/gen/displays/items/Selector8ListMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SelectorExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SelectorExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SelectorExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SelectorExamplesMoldNotifier(this);
		this.requester = new SelectorExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a1366869238" format="h6" mode="normal" value="Tabs facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a971893873" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorTabs context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a971893873.a_306608826" multipleSelection={false} scrollButtons="On">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a971893873.a_306608826.a_685079136" name="tabOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a971893873.a_306608826.a_685079135" name="tabOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a971893873.a_306608826.a_685079134" name="tabOption3" mode="normal" value="option 3">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a971893873.a_306608826.a_685079133" name="tabOption4" mode="normal" value="option 4">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a971893873.a_306608826.a_685079132" name="tabOption5" mode="normal" value="option 5">
								</UiText>
							</UiSelectorTabs>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a1462318803" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_469548041.a1462318803.a_314311381" mode="normal" language="Html" value="Selector as Tabs&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) tabOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) tabOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) tabOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358.a199881765" format="h6" mode="normal" value="Menu facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358.a1506182956" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorMenu context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358.a1506182956.a1135575790" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358.a1506182956.a1135575790.a1705180204" name="menuOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358.a1506182956.a1135575790.a1705180205" name="menuOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358.a1506182956.a1135575790.a1705180206" name="menuOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorMenu>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358.a723230235" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1260562358.a723230235.a885141551" mode="normal" language="Html" value="Selector as Menu(layout=Vertical)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) menuOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) menuOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) menuOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745.a_2099903098" format="h6" mode="normal" value="ComboBox facet with Traceable (cookie is used)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745.a869536862" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745.a869536862.a1298070569" traceable={true} multipleSelection={false} maxMenuHeight={300}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745.a869536862.a1298070569.a1964861993" name="comboBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745.a869536862.a1298070569.a1964861994" name="comboBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745.a869536862.a1298070569.a1964861995" name="comboBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorComboBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745.a_1728811829" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a138767745.a_1728811829.a_846646494" mode="normal" language="Html" value="Selector as ComboBox Traceable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) comboBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) comboBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) comboBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972.a_524648064" format="h6" mode="normal" value="ListBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972.a_632501448" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972.a_632501448.a1460565348" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972.a_632501448.a1460565348.a597981578" name="listBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972.a_632501448.a1460565348.a597981579" name="listBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972.a_632501448.a1460565348.a597981580" name="listBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorListBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972.a_1483144229" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a1543521972.a_1483144229.a_1276210392" mode="normal" language="Html" value="Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) listBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) listBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) listBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622.a721305502" format="h6" mode="normal" value="RadioBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622.a_2025301806" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorRadioBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622.a_2025301806.a_805411318" multipleSelection={false} selected="radioBoxOption1" layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622.a_2025301806.a_805411318.a672231479" name="radioBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622.a_2025301806.a_805411318.a672231480" name="radioBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622.a_2025301806.a_805411318.a672231481" name="radioBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorRadioBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622.a676443428" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_591776622.a676443428.a_662885492" mode="normal" language="Html" value="Selector as RadioBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) radioBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) radioBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) radioBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936.a1122327693" format="h6" mode="normal" value="ToggleBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936.a_1684572473" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorToggleBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936.a_1684572473.a_642916539" multipleSelection={false} selected="toggleBoxOption1" layout="Horizontal" size="Medium">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936.a_1684572473.a_642916539.a596273727" name="toggleBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936.a_1684572473.a_642916539.a596273728" name="toggleBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936.a_1684572473.a_642916539.a596273729" name="toggleBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorToggleBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936.a1426976945" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a181924936.a1426976945.a_1648899749" mode="normal" language="Html" value="Selector as ToggleBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) toggleBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) toggleBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) toggleBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960.a_1339920702" format="h6" mode="normal" value="CheckBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960.a1818360700" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCheckBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960.a1818360700.a_765731418" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960.a1818360700.a_765731418.a1142936736" name="checkBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960.a1818360700.a_765731418.a1142936737" name="checkBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960.a1818360700.a_765731418.a1142936738" name="checkBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorCheckBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960.a1519698825" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_1991537960.a1519698825.a536877441" mode="normal" language="Html" value="Selector as CheckBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_313365388" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_313365388.a643821919" format="h6" mode="normal" value="CollectionBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_313365388.a_1481460131" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCollectionBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_313365388.a_1481460131.a_603236639" multipleSelection={true} allowOther="true">
								<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_313365388.a_1481460131.a_603236639.a1797190553selector8" pageSize={20} itemHeight={30} scrollingMark={true} selection="single">
								</UiList>
							</UiSelectorCollectionBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_313365388.a1745665930" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1810131867.a_313365388.a1745665930.a1740615180" mode="normal" language="Html" value="Selector as CollectionBox(allowOther=true)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(SelectorExamplesMold));
DisplayFactory.register("SelectorExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(SelectorExamplesMold)));