

const I18n = (function () {
	var cache = {};

	var translators = {
		"es" : {
			"no facets" : "no tiene facetas",
			"no properties" : "no tiene propiedades",
			"no methods" : "no tiene métodos",
			"no events" : "no tiene eventos",
			"Value out of range: %.1f-%.1f" : "Valor fuera de rango: %.1f-%.1f",
			"Average" : "Media",
			"Address to search" : "Dirección a buscar",
			"Search" : "Buscar",
			"Close" : "Cerrar",
			"Open search dialog" : "Abrir diálogo de búsqueda",
			"Address not found" : "Dirección no encontrada",
			"Absolute values" : "Valores absolutos",
			"to" : "a"
		}
	};

	function merge(dictionary, lang) {
		if (dictionary == null) dictionary = {};

		return dictionary;
	};

	function addWords(dictionary, words) {
		if (words == null) return;
		for (var index in words) dictionary[index] = words[index];
		return dictionary;
	};

	var loader = {
		load: (lang) => {
			if (cache[lang] == null) cache[lang] = merge(translators[lang], lang);
			return cache[lang];
		}
	};

	return loader;
})();

export default I18n;