import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiActionSwitch from "alexandria-ui-elements/src/displays/components/ActionSwitch";
import UiActionToggle from "alexandria-ui-elements/src/displays/components/ActionToggle";
import UiActionSplit from "alexandria-ui-elements/src/displays/components/ActionSplit";
import UiCopyToClipboard from "alexandria-ui-elements/src/displays/components/CopyToClipboard";
import UiSetDarkMode from "alexandria-ui-elements/src/displays/components/SetDarkMode";
import UiSetLightMode from "alexandria-ui-elements/src/displays/components/SetLightMode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ActionableExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ActionableExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ActionableExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ActionableExamplesMoldNotifier(this);
		this.requester = new ActionableExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1796645908" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1796645908.a1152032633" format="h6" mode="normal" value="Link">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1796645908.a_787743677" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1796645908.a_787743677.a_1047427129" title="operation" target="self" mode="Link" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1796645908.a335196205" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1796645908.a335196205.a_1484521610" mode="normal" language="Html" value="Link(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1103809184" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1103809184.a_918222445" format="h6" mode="normal" value="Button">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1103809184.a_431816442" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1103809184.a_431816442.a460124681" title="operation" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1103809184.a_270807179" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1103809184.a_270807179.a_236174449" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_373360451" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_373360451.a1112508581" format="h6" mode="normal" value="IconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_373360451.a104443175" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_373360451.a104443175.a1967676491" title="operation" target="self" mode="IconButton" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_373360451.a1037792200" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_373360451.a1037792200.a_1708654068" mode="normal" language="Html" value="IconButton(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1864458104" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1864458104.a1640049043" format="h6" mode="normal" value="MaterialIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1864458104.a1104992143" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1864458104.a1104992143.a_819738995" title="operation" target="self" mode="MaterialIconButton" icon="Add" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1864458104.a_1525407895" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1864458104.a_1525407895.a1645517420" mode="normal" language="Html" value="MaterialIconButton(title=&quot;operation&quot;,icon=&quot;Add&quot;) as Action&lt;br/&gt;&lt;br/&gt;
							for icons gallery, refer to &lt;a href=&quot;https://material.io/tools/icons&quot; target=&quot;_blank&quot;&gt;material.io&lt;/a&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a385989998" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a385989998.a_688441946" format="h6" mode="normal" value="Affirmed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a385989998.a1497918731" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a385989998.a1497918731.a182254190" title="operation" target="self" mode="Button" affirmed="Are you sure you want to execute operation?" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a385989998.a824552885" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a385989998.a824552885.a1540274840" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action Affirmed(&quot;Are you sure you want to execute operation?&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a169277496" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a169277496.a1026801710" format="h6" mode="normal" value="Highlight attribute">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a169277496.a1711457196" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a169277496.a1711457196.a1689806000" title="operation 1" target="self" mode="Button" size="Medium" highlighted="Outline">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a169277496.a1711457196.a1689806001" title="operation 2" target="self" mode="Button" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a169277496.a399861471" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a169277496.a399861471.a_13659676" mode="normal" language="Html" value="Button(title=&quot;operation 1&quot;, highlight=&quot;Outline&quot;) as Action&lt;br/&gt;
							Button(title=&quot;operation 2&quot;, highlight=&quot;Fill&quot;) as Action&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_398568056" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_398568056.a_1004171465" format="h6" mode="normal" value="Switch">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_398568056.a143715269" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSwitch context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_398568056.a143715269.a_2108726735" title="edition" target="self" mode="Link" size="Medium" state="Off">
							</UiActionSwitch>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_398568056.a_1526943783" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_398568056.a_1526943783.a1380987540" mode="normal" language="Html" value="Switch(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a666120276" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a666120276.a2114524123" format="h6" mode="normal" value="Signed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a666120276.a_1749909618" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a666120276.a_1749909618.a1564648491" layout="vertical">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a666120276.a_1749909618.a1564648491.a_977650831" title="edition" target="self" mode="Button" signed={{mode:"SimplePassword",text:"Fill your password before continue",reason:""}} size="Medium">
								</UiAction>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a666120276.a_1749909618.a1564648491.a2017549442" format="body2" mode="normal" translate={true} value="1234 must be filled when sign requested">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a666120276.a_274812710" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a666120276.a_274812710.a_664154023" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_489269023" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_489269023.a_1644413544" format="h6" mode="normal" value="Signed facet with reason property">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_489269023.a488292201" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_489269023.a488292201.a1048015750" title="edition" target="self" mode="Button" signed={{mode:"SimplePassword",text:"Fill your password before continue",reason:"Fill reason"}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_489269023.a796459681" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_489269023.a796459681.a270726484" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;, reasonText=&quot;Fill reason&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1480019380" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1480019380.a_721432974" format="h6" mode="normal" value="Toggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1480019380.a_1241340789" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1480019380.a_1241340789.a_1410878621" title="edition" target="self" mode="Toggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1480019380.a_1503224929" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1480019380.a_1503224929.a_829382978" mode="normal" language="Html" value="Toggle(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a500515810" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a500515810.a_1541967113" format="h6" mode="normal" value="IconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a500515810.a1648095908" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a500515810.a1648095908.a_1921412796" title="operation" target="self" mode="IconToggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a500515810.a1664168300" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a500515810.a1664168300.a1114692409" mode="normal" language="Html" value="IconToggle(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a189755557" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a189755557.a125332718" format="h6" mode="normal" value="MaterialIconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a189755557.a1486483273" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a189755557.a1486483273.a1863020322" title="edition" target="self" mode="MaterialIconToggle" icon="FilterList" size="Medium" state="On">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a189755557.a_1313085933" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a189755557.a_1313085933.a26320224" mode="normal" language="Html" value="MaterialIconToggle(title=&quot;edition&quot;, state=On, icon=&quot;FilterList&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2103327907" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2103327907.a964502655" format="h6" mode="normal" value="SplitButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2103327907.a1702905805" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSplit context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2103327907.a1702905805.a1352486147" title="edition" target="self" mode="SplitButton" size="Medium" options={["option 1","option 2"]} defaultOption="option 1">
							</UiActionSplit>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2103327907.a_816471703" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2103327907.a_816471703.a_1922925448" mode="normal" language="Html" value="SplitButton(title=&quot;edition&quot;, options=&quot;option 1&quot; &quot;option 2&quot;, defaultOption=&quot;option 1&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2104722193" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2104722193.a1969535804" format="h6" mode="normal" value="MaterialIconSplitButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2104722193.a_891171791" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSplit context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2104722193.a_891171791.a841951971" title="edition" target="self" mode="MaterialIconSplitButton" icon="Add" size="Medium" options={["option 1","option 2"]} defaultOption="option 1" icon="Add">
							</UiActionSplit>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2104722193.a751593832" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_2104722193.a751593832.a1649473601" mode="normal" language="Html" value="MaterialIconSplitButton(title=&quot;edition&quot;, icon=&quot;Add&quot;, options=&quot;option 1&quot; &quot;option 2&quot;, defaultOption=&quot;option 1&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1423471152" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1423471152.a_1894461108" format="h6" mode="normal" value="AvatarIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1423471152.a2054618371" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1423471152.a2054618371.a331417795" title="I am avatar" target="self" mode="AvatarIconButton" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1423471152.a_948186485" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1423471152.a_948186485.a_1343256171" mode="normal" language="Html" value="AvatarIconButton(title=&quot;I am avatar&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1816343531" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1816343531.a411654560" format="h6" mode="normal" value="CopyToClipboard">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1816343531.a_1416665724" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiCopyToClipboard context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1816343531.a_1416665724.a_179116381" title="Copy to clipboard" target="self" mode="Link" size="Medium">
							</UiCopyToClipboard>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1816343531.a2075321437" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_1816343531.a2075321437.a_1757297985" mode="normal" language="Html" value="Link(title=&quot;Copy to clipboard&quot;, text=&quot;I am text&quot;) as CopyToClipboard(text=&quot;I am text&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_988773086" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_988773086.a_1505286866" format="h6" mode="normal" value="OneTimePassword">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_988773086.a95661293" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_988773086.a95661293.a_689650557" title="One time password" target="self" mode="Link" signed={{mode:"OneTimePassword",text:"Password required",reason:""}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_988773086.a617472433" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_988773086.a617472433.a2060331973" mode="normal" language="Html" value="Link(title=&quot;One time password&quot;) as Action Signed(signText=&quot;Password required&quot;, mode=OneTimePassword)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a1707219739" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a1707219739.a_1072132741" format="h6" mode="normal" value="Toggle app mode">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a1707219739.a_1738336139" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSetDarkMode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a1707219739.a_1738336139.a_1200184733" title="Dark mode" target="self" mode="Link" size="Medium">
							</UiSetDarkMode>
							<UiSetLightMode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a1707219739.a_1738336139.a_1200184711" title="Light mode" target="self" mode="Link" size="Medium">
							</UiSetLightMode>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a1707219739.a1213104198" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a1707219739.a1213104198.a982295920" mode="normal" language="Html" value="Link(title=&quot;Dark mode&quot;) as SetDarkMode
							Link(title=&quot;Light mode&quot;) as SetLightMode">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_212832838" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_212832838.a_1109359580" format="h6" mode="normal" value="Toggle app mode icon">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_212832838.a1324562357" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSetDarkMode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_212832838.a1324562357.a1304384731" title="Dark mode" target="self" mode="MaterialIconButton" icon="Brightness5" size="Medium">
							</UiSetDarkMode>
							<UiSetLightMode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_212832838.a1324562357.a1304384732" title="Light mode" target="self" mode="MaterialIconButton" icon="Brightness7" size="Medium">
							</UiSetLightMode>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_212832838.a775053236" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341678152.a_212832838.a775053236.a584793014" mode="normal" language="Html" value="MaterialIconButton(icon=&quot;Brightness5&quot;, title=&quot;Dark mode&quot;) as SetDarkMode
							MaterialIconButton(icon=&quot;Brightness7&quot;, title=&quot;Light mode&quot;) as SetLightMode">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ActionableExamplesMold));
DisplayFactory.register("ActionableExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ActionableExamplesMold)));