import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class BaseDigitalSignatureNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("text").toSelf().execute((parameters) => this.element.text(parameters.v));
		this.when("document").toSelf().execute((parameters) => this.element.document(parameters.v));
		this.when("sign").toSelf().execute(() => this.element.sign());
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.pushLinked = true;
	};
}