import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TextExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TextExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TextExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TextExamplesMoldNotifier(this);
		this.requester = new TextExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a2073075511" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a2073075511.a_1047510664" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a2073075511.a_20552771" format="filled" layout="vertical" spacing="8">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a2073075511.a_20552771.a1900505514" format="body1 widgetDemo" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a2073075511.a_20552771.a_1123692422" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a2073075511.a_20552771.a_1123692422.a_1194236294" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text1">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a933447060" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a933447060.a1583555129" format="h6" mode="normal" value="No facets with label">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a933447060.a884494623" format="filled" layout="vertical" spacing="8">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a933447060.a884494623.a1703992010" format="body1 widgetDemo" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a933447060.a884494623.a1224608110" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a933447060.a884494623.a1224608110.a_1698871398" mode="normal" language="Html" value="Text text2 as Labeled(&quot;t&iacute;tulo del campo&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value=&quot;lorem ipsum&quot;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_39430384" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_39430384.a1562424903" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_39430384.a983173786" format="filled" layout="vertical" spacing="8">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_39430384.a983173786.a_299975957" format="body1 widgetDemo" mode="normal" helperText="Some important helper text">
							</UiTextEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_39430384.a983173786.a962218671" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_39430384.a983173786.a962218671.a_1108123663" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text3 as Editable(helperText=&quot;Some important helper text&quot;) Labeled(&quot;campo editable&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a205814396" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a205814396.a_1625483637" format="h6" mode="normal" value="Editable facet with pattern">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a205814396.a_975376878" format="filled" layout="vertical" spacing="8">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a205814396.a_975376878.a_496489461" format="body1 widgetDemo" mode="normal" helperText="Some important helper text">
							</UiTextEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a205814396.a_975376878.a_1168617752" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a205814396.a_975376878.a_1168617752.a_1590458771" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text3 as Editable(helperText=&quot;Some important helper text&quot;,pattern=&quot;AAAAAAAA&quot;) Labeled(&quot;campo editable&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1416182343" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1416182343.a1500086360" format="h6" mode="normal" value="Editable facet with error">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1416182343.a_2052414480" format="filled" layout="vertical" spacing="8">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1416182343.a_2052414480.a1794509868" format="body1 widgetDemo" mode="normal">
							</UiTextEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1416182343.a_2052414480.a_1806393718" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1416182343.a_2052414480.a_1806393718.a_812255452" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text3 as Editable Labeled(&quot;campo editable&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1471913833" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1471913833.a_967164829" format="h6" mode="normal" value="Code facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1471913833.a_2123352296" format="filled" layout="vertical" spacing="8">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1471913833.a_2123352296.a_1907154470" format="body1 widgetDemo" mode="normal" language="Html" value="Text(value=&quot;lorem&quot;) text1">
							</UiTextCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1471913833.a_2123352296.a_1439190883" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1471913833.a_2123352296.a_1439190883.a1204905262" mode="normal" language="Html" value="Text textCode1 as Code(language=Html)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;lorem&quot;) text1&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1592547332" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1592547332.a_134442566" format="h6" mode="normal" value="Code and Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1592547332.a1214807553" format="filled" layout="vertical" spacing="8">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1592547332.a1214807553.a1963501591" format="body1 widgetDemo" mode="normal" language="Html" value="&lt;div&gt;Here goes code&lt;/div&gt;">
							</UiTextEditableCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1592547332.a1214807553.a_283358178" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823702562.a_1592547332.a1214807553.a_283358178.a800031979" mode="normal" language="Html" value="Text textCode1 as Code(language=Html) Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;lt;div&amp;gt;Here goes code&amp;lt;/div&amp;gt;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TextExamplesMold));
DisplayFactory.register("TextExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(TextExamplesMold)));