import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiSelectorTabs from "alexandria-ui-elements/src/displays/components/SelectorTabs";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import DisplaysWidgetListMold from "ui-elements/gen/displays/items/WidgetListMold";
import DisplaysWidgetMold from "ui-elements/gen/displays/templates/WidgetMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MobileDocsTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MobileDocsTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MobileDocsTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MobileDocsTemplateNotifier(this);
		this.requester = new MobileDocsTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_860889152" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_860889152.a1835280736" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_860889152.a1835280736.a_252779522" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_860889152.a1835280736.a_1009161305" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_860889152.a1835280736.a_1056502290" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_860889152.a1835280736.a_1056502290.a262827205" title="home" target="self" mode="Link" size="Medium">
							</UiOpenSite>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_860889152.a1835280736.a_1056502290.a_1645886685" mode="normal" value="widgets">
							</UiText>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a496544346" layout="vertical" autoSize={true}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a496544346.a1431604600" layout="vertical flexible">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a496544346.a1431604600.a1222634744" format="airBottom h5" mode="normal">
						</UiText>
						<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a496544346.a1431604600.a1880222249" noItemsMessage="No widgets defined" pageSize={20} itemHeight={200} scrollingMark={true}>
						</UiList>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a496544346.a1073681061" format="air" visible={false} layout="vertical">
						<DisplaysWidgetMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a496544346.a1073681061.a_844765883">
						</DisplaysWidgetMold>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1740887022" layout="vertical end">
					<UiSelectorTabs context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1740887022.a1507150922" multipleSelection={false}>
						<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1740887022.a1507150922.a460182484" name="dataOption" icon="Edit">
						</UiMaterialIcon>
						<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1740887022.a1507150922.a_1961004359" name="catalogOption" icon="List">
						</UiMaterialIcon>
						<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1740887022.a1507150922.a280047303" name="operationOption" icon="PlayArrow">
						</UiMaterialIcon>
						<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1740887022.a1507150922.a_1998982352" name="otherOption" icon="MoreHoriz">
						</UiMaterialIcon>
					</UiSelectorTabs>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(MobileDocsTemplate));
DisplayFactory.register("MobileDocsTemplate", withStyles(styles, { withTheme: true })(withSnackbar(MobileDocsTemplate)));