import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiGrouping from "alexandria-ui-elements/src/displays/components/Grouping";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiGroupingComboBox from "alexandria-ui-elements/src/displays/components/GroupingComboBox";
import DisplaysGrouping1Mold from "ui-elements/gen/displays/items/Grouping1Mold";
import DisplaysGrouping2Mold from "ui-elements/gen/displays/items/Grouping2Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import GroupingExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import GroupingExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class GroupingExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new GroupingExamplesMoldNotifier(this);
		this.requester = new GroupingExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387.a484786766" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387.a_1072265963" format="filledNoAir" layout="horizontal" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387.a_1072265963.a1656192535" format="containerAirMedium" layout="vertical" width="200px" height="-1px" spacing="24">
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387.a_1072265963.a1656192535.a_1140258110" format="whiteBackground" pageSize={5}>
								</UiGrouping>
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387.a_1072265963.a1656192535.a658203683" format="whiteBackground" pageSize={5}>
								</UiGrouping>
							</UiBlock>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387.a_1072265963.a_1145765181" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387.a_797609427" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a1670497387.a_797609427.a_1325807217" mode="normal" language="Html" value="Grouping(collections=list1) gender as Labeled(&quot;gender&quot;)&lt;br/&gt;
							Grouping(collections=list1) ageGroup as Labeled(&quot;age group&quot;)&lt;br/&gt;
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) groupingMold
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636.a_40547739" format="h6" mode="normal" value="ComboBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636.a726031802" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636.a726031802.a2051168410" format="containerAirMedium" layout="horizontal" spacing="24">
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636.a726031802.a2051168410.a_1276914874" format="whiteBackground">
								</UiGroupingComboBox>
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636.a726031802.a2051168410.a_1819928601" format="whiteBackground">
								</UiGroupingComboBox>
							</UiBlock>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636.a726031802.a_1986129913" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636.a_1151894175" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a32385636.a_1151894175.a1297023922" mode="normal" language="Html" value="Grouping(collections=list2) gender as Labeled(&quot;gender&quot;) ComboBox&lt;br/&gt;
							Grouping(collections=list2) ageGroup as Labeled(&quot;age group&quot;) ComboBox&lt;br/&gt;
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list2&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) groupingMold
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a754730049" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a754730049.a1681482528" format="h6" mode="normal" value="No facets with many options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a754730049.a845713241" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a754730049.a845713241.a658241257" format="containerAirMedium" layout="vertical" width="100.0%" height="100.0%" spacing="24">
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a754730049.a845713241.a658241257.a_341394194" format="whiteBackground" pageSize={6}>
								</UiGrouping>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a754730049.a419724324" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a754730049.a419724324.a_918887691" mode="normal" language="Html" value="Grouping(collections=empty) country as Labeled(&quot;country&quot;)&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_99403712" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_99403712.a395056698" format="h6" mode="normal" value="ComboBox facet with many options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_99403712.a1073544050" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_99403712.a1073544050.a_1795138599" format="containerAirMedium" layout="vertical" width="100.0%" height="100.0%" spacing="24">
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_99403712.a1073544050.a_1795138599.a_505714481" format="whiteBackground">
								</UiGroupingComboBox>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_99403712.a2100955553" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_99403712.a2100955553.a_1827333245" mode="normal" language="Html" value="Grouping(collections=empty) country as Labeled(&quot;country&quot;) ComboBox&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_579128180" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_579128180.a1316564421" format="h6" mode="normal" value="AttachedTo facet with many options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_579128180.a500796002" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_579128180.a500796002.a1020716299" format="containerAirMedium" layout="vertical" width="100.0%" height="100.0%" spacing="24">
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_579128180.a500796002.a1020716299.a_670034768" format="whiteBackground" pageSize={6}>
								</UiGrouping>
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_579128180.a500796002.a1020716299.a_227888066" format="whiteBackground" pageSize={6}>
								</UiGrouping>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_579128180.a_1427262740" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471026171.a_579128180.a_1427262740.a1738071732" mode="normal" language="Html" value="Grouping(collections=empty,pageSize=6) country as Labeled(&quot;country&quot;)
							Grouping(collections=empty,pageSize=6) city as Labeled(&quot;city&quot;) AttachedTo(grouping=country)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(GroupingExamplesMold));
DisplayFactory.register("GroupingExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(GroupingExamplesMold)));