import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiFile from "alexandria-ui-elements/src/displays/components/File";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiFileEditable from "alexandria-ui-elements/src/displays/components/FileEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import FileExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import FileExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class FileExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new FileExamplesMoldNotifier(this);
		this.requester = new FileExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_944357153" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_944357153.a386249799" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_944357153.a1056077197" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_944357153.a1056077197.a_922840486" layout="vertical" width="-1px" height="600px">
								<UiFile context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_944357153.a1056077197.a_922840486.a899204558" format="widgetDemo" width="100.0%" height="100.0%">
								</UiFile>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_944357153.a1056077197.a_2030653501" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_944357153.a1056077197.a_2030653501.a1781226973" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_2132574988" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_2132574988.a188907172" format="h6" mode="normal" value="Editable facet with drop zone">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_2132574988.a505063413" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_2132574988.a505063413.a1077574491" layout="vertical" width="-1px" height="600px">
								<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_2132574988.a505063413.a1077574491.a702691054" format="widgetDemo" width="100.0%" height="100.0%" dropZone={true}>
								</UiFileEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_2132574988.a505063413.a_453742990" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1537877339.a_2132574988.a505063413.a_453742990.a1276591869" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%) Editable(showDropZone=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(FileExamplesMold));
DisplayFactory.register("FileExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(FileExamplesMold)));