import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysWidgetSummaryMoldCard from "ui-elements/gen/displays/templates/WidgetSummaryMoldCard";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DocsTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DocsTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DocsTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DocsTemplateNotifier(this);
		this.requester = new DocsTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1773029465" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1773029465.a_357008679" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1773029465.a_357008679.a_1477857079" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1773029465.a_357008679.a2060728434" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1773029465.a_357008679.a2053979778" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1773029465.a_357008679.a2053979778.a_131311472" title="home" target="self" mode="Link" size="Medium">
							</UiOpenSite>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1773029465.a_357008679.a2053979778.a_2040025362" mode="normal" value="widgets">
							</UiText>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251" format="containerAirLarge" layout="wrap" spacing="40">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_149344623" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_149344623.a_1887322377" multiple={{instances:"dataWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_1376863834" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_1376863834.a1972960271" multiple={{instances:"catalogWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a1885192344" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a1885192344.a1764951055" multiple={{instances:"operationWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_1326767729" format="h5 paperFormat" layout="vertical" spacing="8">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1642819251.a_1326767729.a693468719" multiple={{instances:"otherWidgets",arrangement:"Horizontal",noItemsMessage:"no widgets",spacing:16,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DocsTemplate));
DisplayFactory.register("DocsTemplate", withStyles(styles, { withTheme: true })(withSnackbar(DocsTemplate)));