import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSignText from "alexandria-ui-elements/src/displays/components/SignText";
import UiSignDocument from "alexandria-ui-elements/src/displays/components/SignDocument";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DigitalSignatureExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DigitalSignatureExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DigitalSignatureExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DigitalSignatureExamplesMoldNotifier(this);
		this.requester = new DigitalSignatureExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_2050171324" format="h6" mode="normal" value="Sign by using @firma">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016" format="filledNoAir" layout="vertical centercenter">
							<UiSignText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016.a1343638070" title="Sign text" target="self" mode="Link" size="Medium" format="airBottom" signFormat="XAdES">
							</UiSignText>
							<UiSignDocument context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016.a_634312284" title="Sign document" target="self" mode="Link" size="Medium">
							</UiSignDocument>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016.a_743265069" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016.a_743265069.a39960913" mode="normal" cropWithEllipsis={40}>
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016.a137625167" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016.a137625167.a1793041977" mode="normal" cropWithEllipsis={40}>
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016.a1544606491" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a_393998016.a1544606491.a499649827" format="redColor" mode="normal">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a286122121" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a1378014688.a286122121.a1860418698" mode="normal" language="Html" value="Link(title=&quot;Sign text&quot;) as SignText&lt;br/&gt;
							Link(title=&quot;Sign document&quot;) as SignDocument">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_1294293927" format="h6" mode="normal" value="Multiple sign by using @firma">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346" format="filledNoAir" layout="vertical centercenter">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935" layout="vertical" width="90.0%" height="100.0%">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a472967396" multiple={{instances:"signDocumentsField",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:true,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
								</UiMultiple>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a1971698204" format="airTop" layout="horizontal startjustified">
									<UiSignDocument context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a1971698204.a1478805006" title="Sign documents" target="self" mode="Button" readonly={true} size="Small" highlighted="Fill">
									</UiSignDocument>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a1574494221" format="airTop" visible={false} layout="vertical">
									<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a1574494221.a_529245651" multiple={{instances:"signatures",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" cropWithEllipsis={40}>
									</UiMultiple>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a1371600348" format="airTop" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a1371600348.a_1740944766" mode="normal" cropWithEllipsis={40}>
									</UiText>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a_2007617481" format="airTop" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a_525534346.a_923339935.a_2007617481.a1885622296" format="redColor" mode="normal">
									</UiText>
								</UiBlock>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a2077343205" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_557365308.a2138625169.a2077343205.a_722723489" mode="normal" language="Html" value="Link(title=&quot;Sign documents&quot;) as SignDocument">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DigitalSignatureExamplesMold));
DisplayFactory.register("DigitalSignatureExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DigitalSignatureExamplesMold)));